// File:   mousedemo/MousePanel.java
// Description: Panoul crea asculta evenimentele mouse si afiseaza informatie
//              despre unele dintre ele.
// Author: Fred Swartz
// Date:   2005-02-03, 2000-11-29...2002-11-21

package mousedemo;  

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/////////////////////////////////////////////////////// clasa MousePanel
class MousePanel extends JPanel implements MouseListener, MouseMotionListener {
    
   //================================================ variabile instanta
    private int m_lastClickedX = 0;  // coordonata x a clic-ului 
    private int m_lastClickedY = 0;  // coordonata y a clic-ului
    private int m_lastMovedX   = 0;  // coordonata x a deplasarii mouse 
    private int m_lastMovedY   = 0;  // coordonata y a deplasarii mouse
    
   
    //====================================================== constructor
    public MousePanel() {
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(200, 200));
        //--- Adauga ascultatorii mouse.
        this.addMouseListener(this);       // asculta evenimente mouse
        this.addMouseMotionListener(this); // asculta deplasari si tiriri
    }
    
    
    //============================================ metoda paintComponent
    public void paintComponent(Graphics g) {
        super.paintComponent(g);  // deseneaza fundalul si marginile
        g.drawString("Last click: x=" + m_lastClickedX 
                      + ", y=" + m_lastClickedY , 10, 30);
        g.drawString("x=" + m_lastMovedX   + ", y=" + m_lastMovedY 
                      , m_lastMovedX, m_lastMovedY);
    }
    

    //============================================ ascultator mouseClicked
    public void mouseClicked(MouseEvent e) {
        m_lastClickedX = e.getX(); // Salveaza coordonata x a clic-ului
        m_lastClickedY = e.getY(); // Salveaza coordonata y a clic-ului
        this.repaint();            // Deseneaza panoul cu noile valori.
    }
    
  
    //============================================== ascultator mouseMoved
    public void mouseMoved(MouseEvent e) {
        m_lastMovedX = e.getX();
        m_lastMovedY = e.getY();
        this.repaint();
    }
  
  
    //========================================================== ignorate
    //==== celelalte evenimente mouse trebuie sa fie aici, dar nu fac nimic.
    public void mouseDragged (MouseEvent e) {}  // ignora
    //==== aceste evenimente mouse "lente" sunt ignorate.
    public void mouseEntered (MouseEvent e) {}  // ignora
    public void mouseExited  (MouseEvent e) {}  // ignora
    public void mousePressed (MouseEvent e) {}  // ignora
    public void mouseReleased(MouseEvent e) {}  // ignora
}
