import java.io.File;
import java.io.IOException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.*;

/**
This program tests serialization of a Bank object.
If a file with serialized data exists, then it is
loaded. Otherwise the program starts with a new bank.
Bank accounts are added to the bank. Then the bank
object is saved.
*/
public class SerialTester
{
    public static void main(String[] args) throws IOException, ClassNotFoundException
    {
        Bank firstBankOfJava;
        ArrayList <Person> owners;

        File f = new File("bank.dat");
        if(f.exists())
        {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(f));
            firstBankOfJava =(Bank) in.readObject();
            owners = (ArrayList <Person>) in.readObject();
            in.close();
        }
        else
        {
            owners = new ArrayList <Person> ();
            firstBankOfJava = new Bank();
            Person p1 = new Person("Aaaaaaa", "Bbbbbbb");
            owners.add(p1);
            firstBankOfJava.addAccount(new BankAccount(1001, p1, 20000));
            Person p2 = new Person("Bbbbbbb", "Bbbbbbb");
            firstBankOfJava.addAccount(new BankAccount(1015, p2, 10000));
            owners.add(p2);
        }

        // Deposit some money
        BankAccount a = firstBankOfJava.find(1001);
        a.deposit(100);
        System.out.println(a.getAccountNumber() + ":" + a.getBalance() + " " + a.getOwner());
        a = firstBankOfJava.find(1015);
        a.withdraw(50);
        System.out.println(a.getAccountNumber() + ":" + a.getBalance() + " " + a.getOwner());

        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(f));
        out.writeObject(firstBankOfJava);
        out.writeObject(owners);
        
        out.close();
    }
}
