package oop.loggerdemo;
import java.io.*;
import java.util.logging.*;

/**
* Demonstrate Java's logging to a file
*/
public final class SimpleLogger 
{
  SimpleLogger( String logName )
  {
    try 
    {
        // Create an appending file handler
        boolean append = true;
        FileHandler handler = new FileHandler(logName, append);
        handler.setFormatter(new SimpleFormatter()); // needed for simple text output
        // Add to the desired logger
        fLogger = Logger.getLogger("oop.loggerdemo");
        fLogger.addHandler(handler);
    } catch (IOException e) {
        System.err.println("Error creating logger:" + e.getMessage());
        System.exit(1);
    }  
    if ( fLogger == null )
    {
        System.err.println("Log to file " + logName + 
            " cannot be initialized. Quit");
        System.exit(1);
    }
  }
  public static void main(String argv[]) 
  {
    SimpleLogger thing = new SimpleLogger( "SimpleLoger.log" );
    thing.doSomething();
    System.exit(0);
  }

  public void doSomething() {
    //Log messages, one for each level
    //The actual logging output depends on the configured
    //level for this package. Calls to "inapplicable"
    //messages are inexpensive.
    fLogger.setUseParentHandlers(false); // do not print to System.err
    fLogger.finest("this is finest");
    fLogger.finer("this is finer");
    fLogger.fine("this is fine");
    fLogger.config("this is config");
    fLogger.info("this is info");
    fLogger.warning("this is a warning");
    fLogger.severe("this is severe");

    //In the above style, the name of the class and
    //method which has generated a message is placed
    //in the output on a best-efforts basis only.
    //To ensure that this information is always
    //included, use the following "precise log"
    //style instead :
    fLogger.logp(Level.INFO, this.getClass().toString(), "doSomething", "blah");

    //For the very common task of logging exceptions, there is a
    //method which takes a Throwable :
    Throwable ex = new IllegalArgumentException("Some exception text");
    fLogger.log(Level.SEVERE, "Some message", ex);

    //There are convenience methods for exiting and
    //entering a method, which are at Level.FINER :
    fLogger.exiting(this.getClass().toString(), "doSomething");
 }
  private Logger fLogger = null;
} 